/* ------------------------------------------------------------------------------
  File: CHR_ITG3200.h
  Author: CH Robotics
  Version: 1.0
  
  Description: Code for interacting with the ITG3200 gyro
------------------------------------------------------------------------------ */ 

#ifndef	__CHR_ITG3200_H
#define __CHR_ITG3200_H

// HMC5843 function calls
int32_t initializeITG( uint8_t* status_flag );
int32_t getITGData( );

#define	ITG_SLAVE_ADDRESS7	(0x68<<1)

// Register addresses for the ITG3200
#define	ITG_REG_WHOAMI			0x00
#define	ITG_REG_SMPL			0x15
#define	ITG_REG_DLPF_FSSEL	0x16
#define	ITG_REG_INTCONF		0x17
#define	ITG_REG_INTSTAT		0x18

#define	ITG_REG_TEMP_HIGH		0x1B
#define	ITG_REG_TEMP_LOW		0x1C
#define	ITG_REG_GYRO_X_HIGH	0x1D
#define	ITG_REG_GYRO_X_LOW	0x1E
#define	ITG_REG_GYRO_Y_HIGH	0x1F
#define	ITG_REG_GYRO_Y_LOW	0x20
#define	ITG_REG_GYRO_Z_HIGH	0x21
#define	ITG_REG_GYRO_Z_LOW	0x22

#define	ITG_REG_PWR				0x3E

#endif
